<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_187.xsd"
                xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
  <xsl:template match="ns1:SENT_187">
    <!-- TODO: Auto-generated template -->
    <html>
      <head>
              <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});
languative.modifyDictionary("pl", {
sent187: "SENT187 - POTWIERDZENIE ODEBRANIA MIESIĘCZNEGO ZESTAWIENIA INFORMACJI",
selectLanguage: "Wybierz język:",
english: "English",
polish: "Polski",
sentRegisteredAgreementInfo: "DANE INFORMACYJNE O ZGŁOSZENIU",
sentDateOfRegistration: "Data rejestracji:",
sentCreatedUser: "Użytkownik rejestrujący zgłoszenie:",
sentModificationDate: "Data modyfikacji:",
sentModifierUser: "Użytkownik modyfikujący zgłoszenie:",
sentSourceDocumentID: "Numer własny zgłoszenia:",
sentChecksumOfSourceDoc: "Suma kontrolna:",
sentStatus: "Status umowy:",
sentStatus2: "Status",
sentBalanceStatus0: "Zarejestrowany",
sentBalanceStatus2: "Aktywny",
sentBalanceStatus3: "Zakończony",
sentBalanceStatus4: "Anulowany",
sentBalanceCreationDate: "Data utworzenia",
sentBalanceCreator: "Wysyłający",
sentAgreementNumber: "NUMER UMOWY:",
sentInformationAboutSender: "DANE IDENTYFIKACYJNE PODMIOTU SPRZEDAJĄCEGO",
sentIdSisc: "IdSisc:",
sentTraderOrPersonName: "Nazwa podmiotu:",
sentTraderIdentityType: "Rodzaj identyfikatora:",
sentTraderIdentityNumber: "Numer identyfikatora:",
sentInformationAboutRecipient: "DANE IDENTYFIKACYJNE PODMIOTU ODBIERAJĄCEGO",
sentAgreementYear: "Informacja za rok",
sentAgreementMonth: "Informacja za miesiąc",
sentAmount: "Ilość oleju opałowego",
sentAdditionalInfo: "Informacje dodatkowe",
sentComments: "Uwagi do umowy:",
sentBalance: "INFORMACJA O SPRZEDAŻY",
sentSourceDocumentID: "Numer własny zgłoszenia:",
sentAdresses: "Kanały komunikacji zwrotnej",
sentEmail: "Adresy e-mail",
sentWebservice: "Kanał Web service",
sentWS: "Adres Web service zapisany w usłudze e-Klient:",
sentStatusYes: "Tak",
sentStatusNo: "Nie",
sentURL: "Adres URL:",
sentUserName: "Nazwa użytkownika:",
sentPassword: "Hasło:",
sentAuthenticationKey: "Odcisk palca certyfikatu:",
sentStatements: "Oświadczenia",
sentStatements1: "Posiadam upoważnienie do działania w imieniu podmiotu zobowiązanego do wypełnienia i przesłania zgłoszenia",
sentStatementsFullName: "Imię i nazwisko:"
//undefined: "Przykład nieprzypisanej frazy"
});

languative.modifyDictionary("en", {
sent187: "SENT187 - CONFIRMATION OF RECEIPT OF THE MONTHLY STATEMENT OF INFORMATION",
selectLanguage: "Select language:",
english: "English",
polish: "Polski",
sentRegisteredAgreementInfo: "INFORMATION DATA ON THE NOTIFICATION",
sentDateOfRegistration: "Registration date:",
sentCreatedUser: "Registered by:",
sentModificationDate: "Modification date:",
sentModifierUser: "Modifying user:",
sentSourceDocumentID: "Own number of the notification:",
sentChecksumOfSourceDoc: "Checksum:",
sentStatus: "Status:",
sentStatus2: "Status",
sentBalanceStatus0: "Registered",
sentBalanceStatus2: "Active",
sentBalanceStatus3: "Closed",
sentBalanceStatus4: "Canceled",
sentBalanceCreationDate: "Creation Date",
sentBalanceCreator: "Sender",
sentAgreementNumber: "AGREEMENT NUMBER:",
sentInformationAboutSender: "IDENTIFICATION OF THE SELLER",
sentIdSisc: "IdSisc:",
sentTraderOrPersonName: "Entity name:",
sentTraderIdentityType: "Identification type:",
sentTraderIdentityNumber: "Identification number:",
sentInformationAboutRecipient: "IDENTIFICATION DATA OF THE RECEIVING ENTITY",
sentAgreementYear: "Information for the year:",
sentAgreementMonth: "Information for the month:",
sentAmount: "Quantity",
sentAdditionalInfo: "Additional Information",
sentComments: "Comments to the agreement:",
sentBalance: "SALES INFORMATION",
sentSourceDocumentID: "Own number of the notification:",
sentAdresses: "Feedback communication channel",
sentEmail: "E-mail addresses",
sentWebservice: "Web service channel",
sentWS: "Web service address which is indicated in the e-Client service:",
sentStatusYes: "Yes",
sentStatusNo: "No",
sentURL: "URL address:",
sentUserName: "User Name:",
sentPassword: "Password:",
sentAuthenticationKey: "Fingerprint of certificate:",
sentStatements: "Declarations",
sentStatements1: "I am authorized to act on behalf of the entity obliged to fill and send the notification",
sentStatementsFullName: "Full Name:"
//undefined: "Przykład nieprzypisanej frazy"
});

function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}


//]]>
        </script>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }

          @media print {
          body {-webkit-print-color-adjust: exact;}
          }

          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }

          .sent-xslt {
          border-collapse: initial;
          }

          .sent-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#c5c2c2;
          font-weight: normal;
          font-size: 12px;
          margin-bottom: 0;
          border-bottom: 1px solid #c8c9ca;
          }

          .sent-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }

          .sent-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }

          .sent-xslt .grupName {
          font-size: 12px;
          margin: 0 !important;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }

          .sent-xslt .element-2 {
          font-size: 14px;
          font-weight: normal;
          color: #008540;
          }

          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }

          .sent-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }

          .sent-xslt .grupInfoSent {
          min-height: 40px;
          }

          .sent-xslt .grupInfoSent p {
          margin: -2px 0 1px 10px;
          font-size: 16px;
          font-weight: bold;
          }

          .sent-xslt .oilstatus {
          margin: 0 5px 0 -5px;
          margin: 2px 0 1px 10px;
          font-size: 14px;
          padding-bottom: 12px;
          color: red;
          }

          .sent-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }

          .sent-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }

          .sent-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }

          .sent-xslt .table {
          display: table;
          width: 99%;
          margin: 4px 0 15px 7px;
          border-spacing: 0 0;
          border-top: 1px solid #999999;
          border-left: 1px solid #999999;
          }

          .sent-xslt .table-header {
          font-size: 10px;
          font-weight: bold;
          padding: 5px;
          background-color: #ececec;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element {
          font-size: 12px;
          font-weight: normal;
          padding: 2px 5px;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element2 {
          font-size: 12px;
          font-weight: normal;
          padding: 0;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }

          .sent-xslt .table-element3 {
          font-size: 12px;
          font-weight: bold;
          border: 1px #999999;
          border-top-style: solid;
          margin: 0;
          }

          .sent-xslt .table-element p {
          margin-left: 0;
          }

          .sent-xslt .table-element3 p {
          margin-left: 0;
          padding: 0px 5px;
          }

        </style>
      </head>
      <body>
        <div class="sent-xslt">
          <section class="sent-xslt s1">
            <div class="sent-xslt lang">
              <ul>
                <li>
                  <span class="sent-xslt element-1" data-phrase-id="selectLanguage"></span>
                </li>
                <li>
                  <span class="sent-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('en');">
                      <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                    </a>
                  </span>
                </li>
                <li>
                  <span class="sent-xslt element-1">
                    <a href="#" onclick="languative.changeLanguage('pl');">
                      <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                    </a>
                  </span>
                </li>
              </ul>
            </div>
            <h1 data-phrase-id="sent187"></h1>
            <div class="sent-xslt t1">
              <div class="sent-xslt grupInfoSent">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1 sent" data-phrase-id="sentAgreementNumber"></span>
                    <br/>
                    <xsl:value-of select="ns1:AgreementNumber"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentRegisteredAgreementInfo"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <xsl:variable name="creDate" select="substring-before(ns1:RegisteredAgreementInfo/tp:CreationDate, 'T')"/>
                  <xsl:variable name="creTime" select="substring(ns1:RegisteredAgreementInfo/tp:CreationDate, 12,8)"/>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentDateOfRegistration"></span>
                    <xsl:value-of select="$creDate"/>&#160; <xsl:value-of select="$creTime"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentCreatedUser"></span>
                    <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:Creator"/>
                  </p>
                  <xsl:variable name="modDate" select="substring-before(ns1:RegisteredAgreementInfo/tp:ModificationDate, 'T')"/>
                  <xsl:variable name="modTime" select="substring(ns1:RegisteredAgreementInfo/tp:ModificationDate, 12,8)"/>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentModificationDate"></span>
                    <xsl:value-of select="$modDate"/>&#160; <xsl:value-of select="$modTime"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentModifierUser"></span>
                    <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:Modifier"/>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <xsl:if test="ns1:RegisteredAgreementInfo/tp:SourceDocumentId !=''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentSourceDocumentID"></span>
                      <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:SourceDocumentId"/>
                    </p>
                  </xsl:if>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentChecksumOfSourceDoc"></span>
                    <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:ChecksumOfSourceDocument"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentStatus"></span>
                    <xsl:choose>
                      <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '0'">
                        <span data-phrase-id="sentBalanceStatus0"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '2'">
                        <span data-phrase-id="sentBalanceStatus2"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '3'">
                        <span data-phrase-id="sentBalanceStatus3"></span>
                      </xsl:when>
                      <xsl:when test="ns1:RegisteredAgreementInfo/tp:RegistrationStatus = '4'">
                        <span data-phrase-id="sentBalanceStatus4"></span>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="ns1:RegisteredAgreementInfo/tp:RegistrationStatus"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentInformationAboutSender"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderOrPersonName"></span>
                    <xsl:value-of select="ns1:InformationAboutSender/tp:TraderOrPersonName"/>
                  </p>
                  <xsl:if test="ns1:InformationAboutSender/tp:IdSisc !=''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                      <xsl:value-of select="ns1:InformationAboutSender/tp:IdSisc"/>
                    </p>
                  </xsl:if>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                    <xsl:value-of select="ns1:InformationAboutSender/tp:TraderIdentityType"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                    <xsl:value-of select="ns1:InformationAboutSender/tp:TraderIdentityNumber"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentInformationAboutRecipient"></p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderOrPersonName"></span>
                    <xsl:value-of select="ns1:InformationAboutRecipient/tp:TraderOrPersonName"/>
                  </p>
                  <xsl:if test="ns1:InformationAboutRecipient/tp:IdSisc !=''">
                    <p>
                      <span class="sent-xslt element-1" data-phrase-id="sentIdSisc"></span>
                      <xsl:value-of select="ns1:InformationAboutRecipient/tp:IdSisc"/>
                    </p>
                  </xsl:if>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityType"></span>
                    <xsl:value-of select="ns1:InformationAboutRecipient/tp:TraderIdentityType"/>
                  </p>
                  <p>
                    <span class="sent-xslt element-1" data-phrase-id="sentTraderIdentityNumber"></span>
                    <xsl:value-of select="ns1:InformationAboutRecipient/tp:TraderIdentityNumber"/>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName" data-phrase-id="sentBalance"></p>
              <div class="sent-xslt grupInfo">
                <table class="sent-xslt table">
                  <tr>
                    <td class="sent-xslt table-header" data-phrase-id="sentAgreementYear" style="width: 12%"></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentAgreementMonth" style="width: 12%"></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentAmount" style='width: 16%'></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentStatus2" style='width: 10%'></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentBalanceCreationDate" style='width: 17%'></td>
                    <td class="sent-xslt table-header" data-phrase-id="sentBalanceCreator" style='width: 17%'></td>
                  </tr>
                  <xsl:for-each select="ns1:AgreementBalanceInfo">
                    <tr>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceYear"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceMonth"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceAmountOfGoods"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:choose>
                          <xsl:when test="tp:BalanceStatus = '0'">
                            <span data-phrase-id="sentBalanceStatus0"></span>
                          </xsl:when>
                          <xsl:when test="tp:BalanceStatus = '2'">
                            <span data-phrase-id="sentBalanceStatus2"></span>
                          </xsl:when>
                          <xsl:when test="tp:BalanceStatus = '3'">
                            <span data-phrase-id="sentBalanceStatus3"></span>
                          </xsl:when>
                          <xsl:when test="tp:BalanceStatus = '4'">
                            <span data-phrase-id="sentBalanceStatus4"></span>
                          </xsl:when>
                        </xsl:choose>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:variable name="creBalDate" select="substring-before(tp:BalanceCreationDate, 'T')"/>
                        <xsl:variable name="creBalTime" select="substring(tp:BalanceCreationDate, 12,8)"/>
                        <xsl:value-of select="$creBalDate"/>&#160;<xsl:value-of select="$creBalTime"/>
                      </td>
                      <td class="sent-xslt table-element">
                        <xsl:value-of select="tp:BalanceCreator"/>
                      </td>
                    </tr>
                  </xsl:for-each>
                </table>
              </div>
            </div>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
